/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl;
import java.io.File;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;

class XPathFactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xpath.internal";
    private static final SecuritySupport ss = new SecuritySupport();
    private static boolean debug = false;
    private static final Properties cacheProps;
    private static volatile boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class<XPathFactory> SERVICE_CLASS;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public XPathFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String string) throws XPathFactoryConfigurationException {
        if (string == null) {
            throw new NullPointerException();
        }
        XPathFactory xPathFactory = this._newFactory(string);
        if (xPathFactory != null) {
            XPathFactoryFinder.debugPrintln("factory '" + xPathFactory.getClass().getName() + "' was found for " + string);
        } else {
            XPathFactoryFinder.debugPrintln("unable to find a factory for " + string);
        }
        return xPathFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String string) throws XPathFactoryConfigurationException {
        XPathFactory xPathFactory;
        block18: {
            String string2;
            String string3;
            block17: {
                xPathFactory = null;
                string3 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    XPathFactoryFinder.debugPrintln("Looking up system property '" + string3 + "'");
                    string2 = ss.getSystemProperty(string3);
                    if (string2 != null) {
                        XPathFactoryFinder.debugPrintln("The value is '" + string2 + "'");
                        xPathFactory = this.createInstance(string2);
                        if (xPathFactory != null) {
                            return xPathFactory;
                        }
                    } else {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block17;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + string3 + "'");
                    throwable.printStackTrace();
                }
            }
            string2 = ss.getSystemProperty("java.home");
            String string4 = string2 + File.separator + "lib" + File.separator + "jaxp.properties";
            try {
                Object object;
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            File file = new File(string4);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                XPathFactoryFinder.debugPrintln("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            }
                        }
                    }
                }
                object = cacheProps.getProperty(string3);
                XPathFactoryFinder.debugPrintln("found " + (String)object + " in $java.home/jaxp.properties");
                if (object != null && (xPathFactory = this.createInstance((String)object)) != null) {
                    return xPathFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block18;
                exception.printStackTrace();
            }
        }
        assert (xPathFactory == null);
        xPathFactory = this.findServiceProvider(string);
        if (xPathFactory != null) {
            return xPathFactory;
        }
        if (string.equals("http://java.sun.com/jaxp/xpath/dom")) {
            XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            return new XPathFactoryImpl();
        }
        XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class<?> createClass(String string) {
        Class<?> clazz;
        boolean bl = false;
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            bl = true;
        }
        try {
            clazz = this.classLoader != null && !bl ? Class.forName(string, false, this.classLoader) : Class.forName(string);
        }
        catch (Throwable throwable) {
            if (debug) {
                throwable.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    XPathFactory createInstance(String string) throws XPathFactoryConfigurationException {
        XPathFactory xPathFactory = null;
        XPathFactoryFinder.debugPrintln("createInstance(" + string + ")");
        Class<?> clazz = this.createClass(string);
        if (clazz == null) {
            XPathFactoryFinder.debugPrintln("failed to getClass(" + string + ")");
            return null;
        }
        XPathFactoryFinder.debugPrintln("loaded " + string + " from " + XPathFactoryFinder.which(clazz));
        try {
            xPathFactory = (XPathFactory)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            XPathFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return xPathFactory;
    }

    private boolean isObjectModelSupportedBy(final XPathFactory xPathFactory, final String string, AccessControlContext accessControlContext) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return xPathFactory.isObjectModelSupported(string);
            }
        }, accessControlContext);
    }

    private XPathFactory findServiceProvider(final String string) throws XPathFactoryConfigurationException {
        assert (string != null);
        final AccessControlContext accessControlContext = AccessController.getContext();
        try {
            return AccessController.doPrivileged(new PrivilegedAction<XPathFactory>(){

                @Override
                public XPathFactory run() {
                    ServiceLoader<XPathFactory> serviceLoader = ServiceLoader.load(SERVICE_CLASS);
                    for (XPathFactory xPathFactory : serviceLoader) {
                        if (!XPathFactoryFinder.this.isObjectModelSupportedBy(xPathFactory, string, accessControlContext)) continue;
                        return xPathFactory;
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new XPathFactoryConfigurationException(serviceConfigurationError);
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string, ClassLoader classLoader) {
        URL uRL;
        String string2 = string.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = ss.getResourceAsURL(classLoader, string2)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = XPathFactory.class;
    }
}

