/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.fault;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.fault.CodeType;
import com.sun.xml.internal.ws.fault.DetailType;
import com.sun.xml.internal.ws.fault.ReasonType;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.fault.ServerSOAPFaultException;
import com.sun.xml.internal.ws.fault.SubcodeType;
import com.sun.xml.internal.ws.fault.TextType;
import com.sun.xml.internal.ws.util.DOMUtil;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlRootElement(name="Fault", namespace="http://www.w3.org/2003/05/soap-envelope")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"code", "reason", "node", "role", "detail"})
class SOAP12Fault
extends SOAPFaultBuilder {
    @XmlTransient
    private static final String ns = "http://www.w3.org/2003/05/soap-envelope";
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Code")
    private CodeType code;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Reason")
    private ReasonType reason;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Node")
    private String node;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Role")
    private String role;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope", name="Detail")
    private DetailType detail;

    SOAP12Fault() {
    }

    SOAP12Fault(CodeType codeType, ReasonType reasonType, String string, String string2, DetailType detailType) {
        this.code = codeType;
        this.reason = reasonType;
        this.node = string;
        this.role = string2;
        this.detail = detailType;
    }

    SOAP12Fault(CodeType codeType, ReasonType reasonType, String string, String string2, Element element) {
        this.code = codeType;
        this.reason = reasonType;
        this.node = string;
        this.role = string2;
        if (element != null) {
            if (element.getNamespaceURI().equals(ns) && element.getLocalName().equals("Detail")) {
                this.detail = new DetailType();
                for (Element element2 : DOMUtil.getChildElements(element)) {
                    this.detail.getDetails().add(element2);
                }
            } else {
                this.detail = new DetailType(element);
            }
        }
    }

    SOAP12Fault(SOAPFault sOAPFault) {
        this.code = new CodeType(sOAPFault.getFaultCodeAsQName());
        try {
            this.fillFaultSubCodes(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
        this.reason = new ReasonType(sOAPFault.getFaultString());
        this.role = sOAPFault.getFaultRole();
        this.node = sOAPFault.getFaultNode();
        if (sOAPFault.getDetail() != null) {
            this.detail = new DetailType();
            Iterator iterator = sOAPFault.getDetail().getDetailEntries();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                this.detail.getDetails().add(element);
            }
        }
    }

    SOAP12Fault(QName qName, String string, Element element) {
        this(new CodeType(qName), new ReasonType(string), null, null, element);
    }

    CodeType getCode() {
        return this.code;
    }

    ReasonType getReason() {
        return this.reason;
    }

    String getNode() {
        return this.node;
    }

    String getRole() {
        return this.role;
    }

    @Override
    DetailType getDetail() {
        return this.detail;
    }

    @Override
    void setDetail(DetailType detailType) {
        this.detail = detailType;
    }

    @Override
    String getFaultString() {
        return this.reason.texts().get(0).getText();
    }

    @Override
    protected Throwable getProtocolException() {
        try {
            SOAPFault sOAPFault = SOAPVersion.SOAP_12.getSOAPFactory().createFault();
            if (this.reason != null) {
                for (TextType object : this.reason.texts()) {
                    sOAPFault.setFaultString(object.getText());
                }
            }
            if (this.code != null) {
                sOAPFault.setFaultCode(this.code.getValue());
                this.fillFaultSubCodes(sOAPFault, this.code.getSubcode());
            }
            if (this.detail != null && this.detail.getDetail(0) != null) {
                Detail detail = sOAPFault.addDetail();
                for (Node node : this.detail.getDetails()) {
                    Node node2 = sOAPFault.getOwnerDocument().importNode(node, true);
                    detail.appendChild(node2);
                }
            }
            if (this.node != null) {
                sOAPFault.setFaultNode(this.node);
            }
            return new ServerSOAPFaultException(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private void fillFaultSubCodes(SOAPFault sOAPFault, SubcodeType subcodeType) throws SOAPException {
        if (subcodeType != null) {
            sOAPFault.appendFaultSubcode(subcodeType.getValue());
            this.fillFaultSubCodes(sOAPFault, subcodeType.getSubcode());
        }
    }

    private void fillFaultSubCodes(SOAPFault sOAPFault) throws SOAPException {
        Iterator iterator = sOAPFault.getFaultSubcodes();
        SubcodeType subcodeType = null;
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            if (subcodeType == null) {
                subcodeType = new SubcodeType(qName);
                this.code.setSubcode(subcodeType);
                continue;
            }
            SubcodeType subcodeType2 = new SubcodeType(qName);
            subcodeType.setSubcode(subcodeType2);
            subcodeType = subcodeType2;
        }
    }
}

